precision mediump float;

//declare uniforms
uniform sampler2D u_texture;
uniform float radius;
uniform vec2 resolution;
uniform vec2 dir;

//"in" attributes from our vertex shader
varying vec4 v_color;
varying vec2 v_texCoords;

void main() {
	//this will be our RGBA sum
	vec4 sum = vec4(0.0);

	//our original texcoord for this fragment
	vec2 tc = v_texCoords;

	//the amount to blur, i.e. how far off center to sample from
	//1.0 -> blur by one pixel
	//2.0 -> blur by two pixels, etc.
	float blurH = radius/resolution.x;
	float blurV = radius/resolution.y;

	//the direction of our blur
	//(1.0, 0.0) -> x-axis blur
	//(0.0, 1.0) -> y-axis blur
	float hstep = dir.x;
	float vstep = dir.y;

	//apply blurring, using a 9-tap filter with predefined gaussian weights

	sum += texture2D(u_texture, vec2(tc.x - 4.0*blurH*hstep, tc.y - 4.0*blurV*vstep)) * 0.0162162162;
	sum += texture2D(u_texture, vec2(tc.x - 3.0*blurH*hstep, tc.y - 3.0*blurV*vstep)) * 0.0540540541;
	sum += texture2D(u_texture, vec2(tc.x - 2.0*blurH*hstep, tc.y - 2.0*blurV*vstep)) * 0.1216216216;
	sum += texture2D(u_texture, vec2(tc.x - 1.0*blurH*hstep, tc.y - 1.0*blurV*vstep)) * 0.1945945946;

	sum += texture2D(u_texture, vec2(tc.x, tc.y)) * 0.2270270270;

	sum += texture2D(u_texture, vec2(tc.x + 1.0*blurH*hstep, tc.y + 1.0*blurV*vstep)) * 0.1945945946;
	sum += texture2D(u_texture, vec2(tc.x + 2.0*blurH*hstep, tc.y + 2.0*blurV*vstep)) * 0.1216216216;
	sum += texture2D(u_texture, vec2(tc.x + 3.0*blurH*hstep, tc.y + 3.0*blurV*vstep)) * 0.0540540541;
	sum += texture2D(u_texture, vec2(tc.x + 4.0*blurH*hstep, tc.y + 4.0*blurV*vstep)) * 0.0162162162;

	//discard alpha for our simple demo, multiply by vertex color and return
	gl_FragColor = v_color * vec4(sum.rgb, 1.0);
}